IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_GERA_ANALISE_LEAD_TIME]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_GERA_ANALISE_LEAD_TIME]
GO
GO
GO

--EXEC P_GERA_ANALISE_LEAD_TIME 2,1

CREATE PROCEDURE [dbo].[P_GERA_ANALISE_LEAD_TIME](@CD_FABRIC INT, @TP_PROC INT=0) AS 
DECLARE @SQL VARCHAR(6000)
DECLARE @QTDEPEDIDOSANALISE INT
DECLARE @FREQREV INT
DECLARE @CDFILIALANALISELEAD INT 
SET NOCOUNT on;


IF  OBJECT_ID('TEMPDB.dbo.##RsProd_ANALISE_LEAD_TIME') IS NOT NULL
BEGIN
	drop TABLE ##RsProd_ANALISE_LEAD_TIME
END 

IF  OBJECT_ID('TEMPDB.dbo.##RSLEAD_ANALISE_LEAD_TIME') IS NOT NULL
BEGIN
	drop TABLE ##RSLEAD_ANALISE_LEAD_TIME
END 

CREATE TABLE ##RsProd_ANALISE_LEAD_TIME
										(CD_EMP    INT
										, CD_PROD   INT
										, CD_FABRIC INT
										);

CREATE TABLE ##RSLEAD_ANALISE_LEAD_TIME (CD_FABRIC INT
											, LEADTIME  MONEY
											);

 


IF @TP_PROC=0
BEGIN
	
	INSERT INTO   ##RsProd_ANALISE_LEAD_TIME(
		   CD_EMP
		 , CD_PROD
		 , CD_FABRIC)
	SELECT
		   CD_EMP
		 , CD_PROD
		 , CD_FABRIC
	FROM
		EST_PROD
	WHERE  CD_FABRIC = @CD_FABRIC;
END
ELSE
BEGIN
	
	INSERT INTO                           ##RsProd_ANALISE_LEAD_TIME(
		   CD_EMP
		 , CD_PROD
		 , CD_FABRIC)
	SELECT
		   EST_PROD.CD_EMP
		 , EST_PROD.CD_PROD
		 , EST_PROD_FABRIC_GRUPO.CD_CTR_GRUPO
	FROM
		EST_PROD_FABRIC_GRUPO
		INNER JOIN EST_PROD_FABRIC_GRUPO_EST_PROD_FABRIC ON EST_PROD_FABRIC_GRUPO.CD_CTR_GRUPO = EST_PROD_FABRIC_GRUPO_EST_PROD_FABRIC.CD_CTR_GRUPO
		INNER JOIN EST_PROD ON 1 = EST_PROD.CD_EMP
							   AND EST_PROD_FABRIC_GRUPO_EST_PROD_FABRIC.CD_FABRIC = EST_PROD.CD_FABRIC
	WHERE  EST_PROD_FABRIC_GRUPO.CD_CTR_GRUPO = @CD_FABRIC;
END
 
SET @CDFILIALANALISELEAD = ISNULL(( SELECT VALOR AS ORC_PED_CP FROM PRC_EMP_CONFIG WHERE  CD_EMP = 1 AND CD_CHAVE = 'FILIALGERACAOLEADTIME'), 0);
	

IF @CDFILIALANALISELEAD > 0 
BEGIN

	IF @TP_PROC = 0
		BEGIN
			SET @FREQREV = ISNULL((SELECT FREQ_REV FROM
											EST_PROD_FABRIC
										WHERE  CD_FABRIC = @CD_FABRIC
											   AND INDICADOR_SUPRIMENTO = 1
									), 0);
		END;
		ELSE
		BEGIN
			SET @FREQREV = ISNULL(( SELECT FREQ_REV
											FROM
												EST_PROD_FABRIC_GRUPO
											WHERE  CD_CTR_GRUPO = @CD_FABRIC
												   AND INDICADOR_SUPRIMENTO = 1
										), 0);
		END;	
	
	SET @QTDEPEDIDOSANALISE = (SELECT 
									CASE WHEN  @FREQREV = 1 THEN
										2
									WHEN @FREQREV = 2 THEN
										3
									WHEN @FREQREV = 4 THEN
										4
									WHEN @FREQREV = 8 THEN
										6
									WHEN @FREQREV = 12 THEN
										8
									WHEN @FREQREV = 28 THEN
										12
								END)

	set @sql = 'INSERT INTO ##RSLEAD_ANALISE_LEAD_TIME (CD_FABRIC,LEADTIME)
				Select 
					CD_FABRIC, 
					ROUND(ISNULL(SUM(LEAD_TIME),0),0) LEAD_TIME 
				FROM (
		SELECT 
			TOP ' + CONVERT(VARCHAR(max),@QTDEPEDIDOSANALISE) + '
			CD_EMP,         
			CD_FILIAL,          
			CD_PED,         
			CD_FABRIC,           
			QT_IT_PED,         
			QT_IT_NF,               
			CASE WHEN COUNT(LEAD_TIME) >0 THEN               
				(SUM(LEAD_TIME)/ COUNT(LEAD_TIME))          
			ELSE              
				0          
			END LEAD_TIME 
	From  (
			SELECT 
				EST_PED_CP.CD_EMP,  
				EST_PED_CP.CD_FILIAL,  
				EST_PED_CP.CD_PED, 
				EST_PED_CP.CD_FABRIC,   
				EST_PED_CP.CD_FORN, 
				QT_IT_PED, 
				SUM(QT_IT_NF)QT_IT_NF,         
				DATEDIFF(DAY,EST_PED_CP.DT_EMI,    
				EST_NF_ENT.DT_ENT) LEAD_TIME 
			FROM (
					SELECT        
						EST_PED_CP.CD_EMP,        
						EST_PED_CP.CD_FILIAL,        
						EST_PED_CP.CD_PED,       
						EST_PROD.CD_FABRIC,       
						EST_PED_CP.CD_FORN,       
						SUM((EST_PED_CP_IT.QT_IT * EST_PED_CP_IT.QT_EMB) - ISNULL(EST_PED_CP_IT_CANCEL_SLD.QT_PROD, 0)) AS QT_IT_PED,       
						EST_PED_CP.DT_EMI   
					 FROM                             
						EST_PED_CP INNER JOIN EST_PED_CP_IT ON 
						EST_PED_CP.CD_EMP = EST_PED_CP_IT.CD_EMP AND        
						EST_PED_CP.CD_FILIAL = EST_PED_CP_IT.CD_FILIAL AND        
						EST_PED_CP.CD_PED = EST_PED_CP_IT.CD_PED        
						LEFT OUTER JOIN EST_PED_CP_IT_CANCEL_SLD ON        
						EST_PED_CP_IT.CD_EMP = EST_PED_CP_IT_CANCEL_SLD.CD_EMP AND        
						EST_PED_CP_IT.CD_FILIAL = EST_PED_CP_IT_CANCEL_SLD.CD_FILIAL AND        
						EST_PED_CP_IT.CD_PED = EST_PED_CP_IT_CANCEL_SLD.CD_PED AND       
						EST_PED_CP_IT.CD_PROD = EST_PED_CP_IT_CANCEL_SLD.CD_PROD       
						 
						INNER JOIN ##RsProd_ANALISE_LEAD_TIME EST_PROD ON       
						EST_PED_CP_IT.CD_EMP = EST_PROD.CD_EMP AND        
						EST_PED_CP_IT.CD_PROD = EST_PROD.CD_PROD   
					 GROUP BY       
						EST_PED_CP.CD_EMP,        
						EST_PED_CP.CD_FILIAL,        
						EST_PROD.CD_FABRIC,       
						EST_PED_CP.CD_FORN,       
						EST_PED_CP.CD_PED,       
						EST_PED_CP.DT_EMI) EST_PED_CP 
					INNER  JOIN EST_NF_ENT_PED_CP ON  
					EST_PED_CP.CD_EMP = EST_NF_ENT_PED_CP.CD_EMP AND  
					EST_PED_CP.CD_FILIAL = EST_NF_ENT_PED_CP.CD_FILIAL AND  
					EST_PED_CP.CD_PED = EST_NF_ENT_PED_CP.CD_PED 
					INNER JOIN (SELECT                    
									EST_NF_ENT.CD_EMP,                    
									EST_NF_ENT.CD_FILIAL,                    
									EST_NF_ENT.CD_NF,                    
									EST_PROD.CD_FABRIC,                   
									SUM(EST_NF_ENT_IT.QT_IT) AS QT_IT_NF,                    
									EST_NF_ENT.DT_ENT             
								FROM                          
									EST_NF_ENT INNER JOIN EST_NF_ENT_IT ON                
									EST_NF_ENT.CD_EMP = EST_NF_ENT_IT.CD_EMP AND                
									EST_NF_ENT.CD_FILIAL = EST_NF_ENT_IT.CD_FILIAL AND                
									EST_NF_ENT.CD_NF = EST_NF_ENT_IT.CD_NF                
									INNER JOIN ##RsProd_ANALISE_LEAD_TIME EST_PROD ON                
									EST_NF_ENT_IT.CD_EMP = EST_PROD.CD_EMP AND                
									EST_NF_ENT_IT.CD_PROD = EST_PROD.CD_PROD              
								GROUP BY               
									EST_NF_ENT.CD_EMP,                
									EST_NF_ENT.CD_FILIAL,                
									EST_NF_ENT.CD_NF,               
									EST_PROD.CD_FABRIC,               
									EST_NF_ENT.DT_ENT)  EST_NF_ENT ON    
					 EST_NF_ENT_PED_CP.CD_EMP = EST_NF_ENT.CD_EMP AND    
					 EST_NF_ENT_PED_CP.CD_FILIAL = EST_NF_ENT.CD_FILIAL AND    
					 EST_NF_ENT_PED_CP.CD_NF = EST_NF_ENT.CD_NF 
					 WHERE 
						EST_PED_CP.DT_EMI <= EST_NF_ENT.DT_ENT
				GROUP BY   
					EST_PED_CP.CD_EMP,    
					EST_PED_CP.CD_FILIAL,    
					EST_PED_CP.CD_PED,   
					EST_PED_CP.CD_FABRIC,   
					EST_PED_CP.CD_FORN,   
					QT_IT_PED,       
					DATEDIFF(DAY,EST_PED_CP.DT_EMI, EST_NF_ENT.DT_ENT)) A 
	 WHERE  
		CD_EMP = 1 
		AND CD_FILIAL = ' + CONVERT(VARCHAR(max),@CDFILIALANALISELEAD) + 
		' AND QT_IT_PED > 0 
		AND ((QT_IT_NF /QT_IT_PED) * 100) > 90  
	GROUP BY     
		CD_EMP,      
		CD_FILIAL,      
		CD_PED,     
		CD_FABRIC,        
		QT_IT_PED,     
		QT_IT_NF
	Order By  
		CD_PED DESC) LT
	GROUP BY
	CD_FABRIC'

execute (@sql)



IF @TP_PROC = 0
	BEGIN
		UPDATE f
		  SET
			  f.LEAD_TIME = l.LEADTIME
			, f.DT_PROC_LEAD_TIME = GETDATE()
		FROM   EST_PROD_FABRIC f
			   INNER JOIN ##RSLEAD_ANALISE_LEAD_TIME l ON f.CD_FABRIC = l.CD_FABRIC
														  AND f.LEAD_TIME <> l.LEADTIME;
	END;
	ELSE
	BEGIN
		UPDATE f
		  SET
			  f.LEAD_TIME = l.LEADTIME
			, f.DT_PROC_LEAD_TIME = GETDATE()
		FROM   EST_PROD_FABRIC_GRUPO f
			   INNER JOIN ##RSLEAD_ANALISE_LEAD_TIME l ON f.CD_CTR_GRUPO = l.CD_FABRIC
														  AND f.LEAD_TIME <> l.LEADTIME;
	END;


	IF  OBJECT_ID('TEMPDB.dbo.##RsProd_ANALISE_LEAD_TIME') IS NOT NULL
	BEGIN
		drop TABLE ##RsProd_ANALISE_LEAD_TIME
	END 

	IF  OBJECT_ID('TEMPDB.dbo.##RSLEAD_ANALISE_LEAD_TIME') IS NOT NULL
	BEGIN
		drop TABLE ##RSLEAD_ANALISE_LEAD_TIME
	END 
END



